<?php
/**
 * Test Currency Helper Functions
 * Run this file to test the INR/USDT currency detection
 */

require_once "api/currency_helper.php";

echo "<h1>Currency Helper Test</h1>";
echo "<pre>";

$exchange_rate = 85; // 1 USDT = 85 INR

echo "=== Test Cases (Exchange Rate: $exchange_rate) ===\n\n";

// Test 1: USDT without suffix
echo "Test 1: Input '100' (USDT)\n";
$result = parse_amount_with_currency("100", $exchange_rate);
print_r($result);
echo "\n";

// Test 2: USDT with 'u' suffix
echo "Test 2: Input '100u' (USDT)\n";
$result = parse_amount_with_currency("100u", $exchange_rate);
print_r($result);
echo "\n";

// Test 3: INR with 'i' suffix
echo "Test 3: Input '8500i' (INR)\n";
$result = parse_amount_with_currency("8500i", $exchange_rate);
print_r($result);
echo "\n";

// Test 4: Decimal USDT
echo "Test 4: Input '100.50u' (USDT)\n";
$result = parse_amount_with_currency("100.50u", $exchange_rate);
print_r($result);
echo "\n";

// Test 5: Decimal INR
echo "Test 5: Input '8542.50i' (INR)\n";
$result = parse_amount_with_currency("8542.50i", $exchange_rate);
print_r($result);
echo "\n";

// Test 6: Invalid format
echo "Test 6: Input 'invalid' (should return null)\n";
$result = parse_amount_with_currency("invalid", $exchange_rate);
var_dump($result);
echo "\n";

echo "\n=== Conversion Verification ===\n\n";
echo "100 USDT × 85 = 8500 INR ✓\n";
echo "8500 INR ÷ 85 = 100 USDT ✓\n";

echo "</pre>";

echo "<h2>Usage Examples</h2>";
echo "<pre>";
echo htmlspecialchars('
// In your PHP code:
require_once "api/currency_helper.php";

$exchange_rate = 85; // Get from database

// Parse user input
$result = parse_amount_with_currency("8500i", $exchange_rate);

if ($result) {
    $amount_usdt = $result["amount_usdt"];  // 100
    $amount_inr = $result["amount_inr"];    // 8500
    $currency = $result["currency"];         // "INR"
    
    // Use these values to insert into database
    echo "Deposit: " . $amount_usdt . " USDT (" . $amount_inr . " INR)";
}
');
echo "</pre>";
