<?php
// file: api/get_logs.php
require_once "../config.php";

header('Content-Type: application/json');

$date = $_GET['date'] ?? date('Y-m-d');
$start = $date . " 00:00:00";
$end   = $date . " 23:59:59";

$stmt = $conn->prepare("
    SELECT id,
           telegram_user_id,
           telegram_username,
           type,
           amount,
           remark,
           operator_name,
           created_at
    FROM transactions
    WHERE created_at BETWEEN ? AND ?
    ORDER BY created_at ASC
");
$stmt->bind_param("ss", $start, $end);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

echo json_encode($data);

$stmt->close();
$conn->close();
