<?php
// file: api/generate_link.php
require_once "../config.php";
require_once "../link_crypto.php";

header('Content-Type: application/json');

// Get parameters
$uid = $_GET['uid'] ?? 0;
$gid = $_GET['gid'] ?? 0;
$start_date = $_GET['start_date'] ?? '';
$end_date = $_GET['end_date'] ?? '';

if (!$uid || !$start_date || !$end_date) {
    http_response_code(400);
    echo json_encode(["error" => "Missing parameters"]);
    exit;
}

// Generate secure token
$token = generate_secure_token($uid, $gid, $start_date, $end_date);

// Build full URL - use rawurlencode for base64 tokens
// Detect the base path dynamically (works for both /ledger/ and /ledger2/)
$script_path = dirname(dirname($_SERVER['SCRIPT_NAME'])); // Gets /ledger or /ledger2
$base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
$link = $base_url . $script_path . "/user_ledger.php?token=" . rawurlencode($token);

echo json_encode([
    "token" => $token,
    "link" => $link
]);
?>