<?php
/**
 * API ENDPOINT TESTER
 * Upload this file to test if your APIs are accessible
 * Access via: https://partylimes.com/ledger/test_api.php
 */

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>API Endpoint Test</title>
    <style>
        body { font-family: Arial; padding: 20px; background: #f5f5f5; }
        .test-box { background: white; padding: 20px; margin: 10px 0; border-radius: 5px; }
        .success { color: green; }
        .error { color: red; }
        .info { color: blue; }
        pre { background: #f0f0f0; padding: 10px; border-radius: 3px; overflow-x: auto; }
        button { background: #4CAF50; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; }
        button:hover { background: #45a049; }
    </style>
</head>
<body>
    <h1>🔍 Ledger API Endpoint Test</h1>
    
    <div class="test-box">
        <h2>Test 1: Set Exchange Rate API</h2>
        <button onclick="testSetRate()">Test Set Rate API</button>
        <div id="rate-result"></div>
    </div>
    
    <div class="test-box">
        <h2>Test 2: Add Transaction API</h2>
        <button onclick="testAddTransaction()">Test Add Transaction API</button>
        <div id="tx-result"></div>
    </div>
    
    <div class="test-box">
        <h2>Test 3: Get Logs API</h2>
        <button onclick="testGetLogs()">Test Get Logs API</button>
        <div id="logs-result"></div>
    </div>

    <script>
        const API_SECRET = 'test_ledger_9f8e7d6c5b4a';
        
        async function testSetRate() {
            const result = document.getElementById('rate-result');
            result.innerHTML = '<p class="info">Testing...</p>';
            
            try {
                const formData = new FormData();
                formData.append('api_secret', API_SECRET);
                formData.append('exchange_rate', '108');
                
                const response = await fetch('api/set_exchange.php', {
                    method: 'POST',
                    body: formData
                });
                
                const text = await response.text();
                const status = response.status;
                
                if (status === 200) {
                    result.innerHTML = `
                        <p class="success">✅ SUCCESS! API is working</p>
                        <p><strong>Status:</strong> ${status}</p>
                        <pre>${text}</pre>
                    `;
                } else {
                    result.innerHTML = `
                        <p class="error">❌ FAILED</p>
                        <p><strong>Status:</strong> ${status}</p>
                        <pre>${text}</pre>
                    `;
                }
            } catch (error) {
                result.innerHTML = `<p class="error">❌ Error: ${error.message}</p>`;
            }
        }
        
        async function testAddTransaction() {
            const result = document.getElementById('tx-result');
            result.innerHTML = '<p class="info">Testing...</p>';
            
            try {
                const formData = new FormData();
                formData.append('api_secret', API_SECRET);
                formData.append('telegram_user_id', '123456');
                formData.append('telegram_username', 'test_user');
                formData.append('type', 'IN');
                formData.append('amount', '100');
                formData.append('remark', 'API Test');
                formData.append('group_id', '1');
                formData.append('operator_name', 'admin');
                formData.append('currency', 'USDT');
                
                const response = await fetch('api/add_transaction.php', {
                    method: 'POST',
                    body: formData
                });
                
                const text = await response.text();
                const status = response.status;
                
                if (status === 200) {
                    result.innerHTML = `
                        <p class="success">✅ SUCCESS! API is working</p>
                        <p><strong>Status:</strong> ${status}</p>
                        <pre>${text}</pre>
                    `;
                } else {
                    result.innerHTML = `
                        <p class="error">❌ FAILED</p>
                        <p><strong>Status:</strong> ${status}</p>
                        <pre>${text}</pre>
                    `;
                }
            } catch (error) {
                result.innerHTML = `<p class="error">❌ Error: ${error.message}</p>`;
            }
        }
        
        async function testGetLogs() {
            const result = document.getElementById('logs-result');
            result.innerHTML = '<p class="info">Testing...</p>';
            
            try {
                const today = new Date().toISOString().split('T')[0];
                const response = await fetch(`api/get_logs.php?date=${today}`);
                
                const text = await response.text();
                const status = response.status;
                
                if (status === 200) {
                    result.innerHTML = `
                        <p class="success">✅ SUCCESS! API is working</p>
                        <p><strong>Status:</strong> ${status}</p>
                        <pre>${text}</pre>
                    `;
                } else {
                    result.innerHTML = `
                        <p class="error">❌ FAILED</p>
                        <p><strong>Status:</strong> ${status}</p>
                        <pre>${text}</pre>
                    `;
                }
            } catch (error) {
                result.innerHTML = `<p class="error">❌ Error: ${error.message}</p>`;
            }
        }
    </script>
</body>
</html>
