-- ============================================
-- SETTINGS TABLE SCHEMA
-- Create this table in your production database
-- ============================================

-- Create settings table for storing exchange rate and other app settings
CREATE TABLE IF NOT EXISTS settings (
    id INT PRIMARY KEY,
    exchange_rate DECIMAL(10,4) NOT NULL DEFAULT 1.0000,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert default exchange rate
INSERT INTO settings (id, exchange_rate) 
VALUES (1, 108.0000)
ON DUPLICATE KEY UPDATE id=id;

-- ============================================
-- VERIFY INSTALLATION
-- ============================================
-- Run this after creating the table to verify it worked:
-- SELECT * FROM settings WHERE id = 1;
-- Expected result: 1 row with exchange_rate = 108.0000
