<?php
session_start();
require_once "config.php";

if (isset($_SESSION['admin_username'])) {
    header("Location: dashboard.php");
    exit;
}
if (!isset($_GET['lang'])) {
    header("Location: login.php?lang=zh");
    exit;
}


$error = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $username = $_POST["username"] ?? "";
    $password = $_POST["password"] ?? "";

    $stmt = $conn->prepare("SELECT id, username, password, name FROM admin_users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($row = $res->fetch_assoc()) {
        if (password_verify($password, $row["password"])) {
            $_SESSION["admin_username"] = $row["username"];
            $_SESSION["admin_name"] = $row["name"];
            header("Location: dashboard.php");
            exit;
        } else {
            $error = "Invalid password!";
        }
    } else {
        $error = "User not found!";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Ledger Admin Login</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
<div class="container" style="max-width:400px; margin-top:80px;">
<div class="card">
<div class="card-body">
<h3 class="text-center">Admin Login</h3>

<?php if($error): ?>
<div class="alert alert-danger"><?php echo $error; ?></div>
<?php endif; ?>

<form method="POST">
<label class="form-label">Username</label>
<input type="text" name="username" class="form-control" required>

<label class="form-label mt-3">Password</label>
<input type="password" name="password" class="form-control" required>

<button class="btn btn-primary w-100 mt-4">Login</button>
</form>
</div>
</div>
</div>
</body>
</html>
