from telegram.ext import Updater, MessageHandler, Filters
import logging

# ================== CONFIG ==================
BOT_TOKEN = "8281940179: AAGTwBb0DSTtrLQuBYcV25Z5sZ2GJQf11og"  # @intro_cyp_bot

WELCOME_MESSAGE = (
    "💬 WELCOME MESSAGE\n\n"
    "👋 Welcome to our Exchange Service!\n"
    "Please read our Terms & Conditions before using the service.\n\n"
    "📌 EXCHANGE RATES\n\n"
    "💰 Clean Funds\n"
    "1 USDT = 98 INR\n"
    "Minimum Deposit: 200 USDT\n"
    "🛡️ Account Protection Time (Clean Funds)\n"
    "Day 1: 40 minutes\n"
    "Day 2: 30 minutes\n"
    "Day 3: 20 minutes\n\n"
    "💰 Gaming Funds\n"
    "1 USDT = 105 INR\n"
    "Minimum Deposit: 400 USDT\n"
    "🛡️ Account Protection Time (Gaming Funds)\n"
    "Day 1: 20 minutes\n"
    "Day 2: 15 minutes\n"
    "Day 3: 10 minutes\n\n"
    "⚠️ IMPORTANT NOTES\n"
    "Protection time applies to the same account.\n"
    "If you use a new account on the next day, the first day protection time will apply again.\n"
    "🛡️ Account Block / Freeze / Lien Condition\n"
    "If the account becomes blocked, lien, or frozen during the protection time, the company will compensate.\n"
    "For compensation, the customer must provide all required documents and information.\n\n"
    "✔️ By using our service, you agree to these terms and conditions.\n"
    "📩 For support, please message us anytime.\n"
)

# ================== LOGGING ==================
logging.basicConfig(
    format="%(asctime)s - %(name)s - %(levelname)s - %(message)s",
    level=logging.INFO,
)
logger = logging.getLogger(__name__)


# ================== HANDLERS ==================
def handle_new_members(update, context):
    """
    Whenever someone joins the group, send the welcome message.
    No /commands, no 'hi' keyword.
    """
    chat = update.effective_chat
    for member in update.message.new_chat_members:
        # ignore bots
        if member.is_bot:
            continue
        logger.info(f"New member joined: {member.id} - {member.full_name}")
        chat.send_message(WELCOME_MESSAGE)


def error_handler(update, context):
    logger.error("Error in intro bot:", exc_info=context.error)


# ================== MAIN ==================
def main():
    updater = Updater(BOT_TOKEN, use_context=True)
    dp = updater.dispatcher

    # New member joins → auto welcome
    dp.add_handler(MessageHandler(Filters.status_update.new_chat_members, handle_new_members))

    dp.add_error_handler(error_handler)

    updater.start_polling()
    logger.info("Intro bot started…")
    updater.idle()


if __name__ == "__main__":
    main()