<?php
require_once "../config.php";

header('Content-Type: application/json');

$group_id = $_GET['group_id'] ?? null;

// 1. Validation and Error Logging
if (!$group_id) {
    error_log("API Error: group_id missing in request.");
    echo json_encode(["error" => "group_id is required"]);
    exit;
}

try {
    // 2. Corrected SQL: Removed trailing comma and added placeholder
    $stmt = $conn->prepare("
        SELECT exchange_rate, to_pay_rate 
        FROM settings 
        WHERE group_id = ? 
        LIMIT 1
    ");
    
    $stmt->bind_param("s", $group_id);
    $stmt->execute();
    $result = $stmt->get_result();

    // 3. Fetch only the first row
    $data = $result->fetch_assoc();

    if ($data) {
        // Return single object: {"exchange_rate": 50, "to_pay_rate": 51}
        echo json_encode($data);
    } else {
        // Log if group_id was not found and return empty/error
        error_log("API Warning: No settings found for group_id: $group_id");
        echo json_encode(["error" => "No data found for this group"]);
    }

    $stmt->close();
} catch (Exception $e) {
    error_log("SQL Error: " . $e->getMessage());
    echo json_encode(["error" => "Internal server error"]);
}

$conn->close();