<?php
require_once "config.php";
require_once "link_crypto.php";

// Support both token (new) and old (uid/date) parameters
$token = $_GET["token"] ?? null;
$uid = null;
$start_date = null;
$end_date = null;

// Try token-based decryption first
if ($token) {
    $payload = decrypt_secure_token($token);
    if ($payload && !is_token_expired($payload['created'], 24)) {
        $uid = $payload['uid'];
        $start_date = $payload['start_date'];
        $end_date = $payload['end_date'];
    }
}

// Fallback to old parameter format for backward compatibility
if (!$uid) {
    $uid = $_GET["uid"] ?? null;
    $start_date = $_GET["start_date"] ?? null;
    $end_date = $_GET["end_date"] ?? null;
}

$date = $_GET["date"] ?? null;

// Determine filename and query based on parameters
if ($uid && $start_date && $end_date) {
    // New format: specific user with date range
    $filename = "user_ledger_{$uid}_" . date('Y-m-d', strtotime($start_date)) . "_to_" . date('Y-m-d', strtotime($end_date)) . ".csv";
    
    header("Content-Type: text/csv");
    header("Content-Disposition: attachment; filename=$filename");
    
    $output = fopen("php://output", "w");
    
    // CSV headers
    fputcsv($output, ["Date", "User", "Type", "Amount", "Exchange Rate", "Remark", "Operator"]);
    
    // Fetch rows for specific user and date range
    $stmt = $conn->prepare("
        SELECT * FROM transactions 
        WHERE telegram_user_id = ? 
        AND created_at BETWEEN ? AND ? 
        ORDER BY created_at DESC
    ");
    $stmt->bind_param("iss", $uid, $start_date, $end_date);
    
} else {
    // Old format: all users for a specific date (backward compatibility with dashboard)
    $date = $date ?? date("Y-m-d");
    $filename = "ledger_$date.csv";
    
    header("Content-Type: text/csv");
    header("Content-Disposition: attachment; filename=$filename");
    
    $output = fopen("php://output", "w");
    
    // CSV headers
    fputcsv($output, ["Date", "User", "Type", "Amount", "Exchange Rate", "Remark", "Operator"]);
    
    // Fetch rows for all users on specific date
    $stmt = $conn->prepare("
        SELECT * FROM transactions 
        WHERE DATE(created_at) = ? 
        ORDER BY created_at DESC
    ");
    $stmt->bind_param("s", $date);
}

$stmt->execute();
$res = $stmt->get_result();

while($row = $res->fetch_assoc()) {
    fputcsv($output, [
        $row["created_at"],
        $row["telegram_username"],
        $row["type"],
        $row["amount"],
        $row["transaction_exchange_rate"] ?? 'N/A',
        $row["remark"],
        $row["operator_name"]
    ]);
}

fclose($output);
$stmt->close();
$conn->close();
exit;
?>
