<?php
require_once "config.php";


if (!isset($_SESSION['admin_username'])) {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['lang']) && !isset($_GET['group_id']) && !isset($_GET['date'])) {
    header("Location: dashboard.php?lang=zh");
    exit;
}

$date = $_GET['date'] ?? date("Y-m-d");

// select all group list
$group_list_q = $conn->prepare("
    SELECT group_id, group_name from settings
");
$group_list_q->execute();
$group_list_r = $group_list_q->get_result();

//  select single group
$stmt = $conn->prepare("
    SELECT group_id, group_name 
    FROM settings 
    ORDER BY id ASC 
    LIMIT 1
");

$stmt->execute();
$result = $stmt->get_result();

// 3. Fetch only the first row
$selected_group = $result->fetch_assoc();


if (!$selected_group) {
    echo "Telegram Group is not created, please create group and check again.";
    exit;
}

$group_id = ($_GET['group_id'] ?? '') !== '' ? $_GET['group_id'] : $selected_group['group_id'];


// =========================
// LOAD / UPDATE SETTINGS
// =========================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_settings'])) {
    $new_ex_rate = isset($_POST['exchange_rate']) ? (float)$_POST['exchange_rate'] : 1.0;
    $new_fee     = isset($_POST['fee_rate']) ? (float)$_POST['fee_rate'] : 0.0;

    $stmt = $conn->prepare("UPDATE settings SET exchange_rate = ?, fee_rate = ? WHERE group_id = ?");
    $stmt->bind_param("dds", $new_ex_rate, $new_fee, $group_id);
    $stmt->execute();
    $stmt->close();
}

// Fetch settings
$settings_stmt = $conn->prepare("SELECT exchange_rate, to_pay_rate, fee_rate FROM settings WHERE group_id = ?");
$settings_stmt->bind_param("s", $group_id);
$settings_stmt->execute();
$settings_res = $settings_stmt->get_result();
$settings = $settings_res->fetch_assoc() ?: ['exchange_rate' => 1.0, 'fee_rate' => 0.0];

$settings_stmt->close();

$exchange_rate = (float)$settings['exchange_rate'];
$payout_rate = (float)$settings['to_pay_rate'];
$fee_rate      = (float)$settings['fee_rate'];

// =========================
// SUMMARY FOR SELECTED DATE
// =========================
$sum_stmt = $conn->prepare("
    SELECT type, SUM(amount) AS total 
    FROM transactions 
    WHERE DATE(created_at) = ? 
    AND group_id = ?
    GROUP BY type
");
$sum_stmt->bind_param("ss", $date, $group_id);
$sum_stmt->execute();
$sum_res = $sum_stmt->get_result();

$total_in = 0;
$total_out = 0;

while ($row = $sum_res->fetch_assoc()) {
    if ($row['type'] === 'IN')  $total_in  = (float)$row['total'];
    if ($row['type'] === 'OUT') $total_out = (float)$row['total'];
}
$sum_stmt->close();

$total_in_rs = $total_in * $exchange_rate;
$total_out_rs = $total_out * $exchange_rate;

$net = $total_in - $total_out;



$in_usdt = $exchange_rate > 0 ? $total_in : 0.0;
$fee_usdt = $in_usdt * ($fee_rate / 100);

$in_ustd_in_inr = $in_usdt * $exchange_rate;
// $should_payout_usdt = $in_usdt - $fee_usdt;
$should_payout_usdt = $in_ustd_in_inr / $payout_rate;
$out_usdt = $exchange_rate > 0 ? $total_out : 0.0;
$pending_usdt = $should_payout_usdt - $out_usdt;

$profit_ustd = $in_usdt - $should_payout_usdt;

$profit_in_rs = $profit_ustd * $exchange_rate;

// =========================
// FETCH TRANSACTION LOGS
// =========================
$logs_stmt = $conn->prepare("
    SELECT * FROM transactions 
    WHERE DATE(created_at) = ? 
    AND group_id = ?
    ORDER BY created_at DESC
");
$logs_stmt->bind_param("ss", $date, $group_id);
$logs_stmt->execute();
$logs = $logs_stmt->get_result();

// =========================
// STATS: BY REMARK, USER, OPERATOR
// =========================
$remark_stmt = $conn->prepare("
    SELECT 
        remark,
        SUM(CASE WHEN type='IN'  THEN amount ELSE 0 END) AS in_total,
        SUM(CASE WHEN type='OUT' THEN amount ELSE 0 END) AS out_total
    FROM transactions
    WHERE DATE(created_at) = ?
    AND group_id = ?
    GROUP BY remark
    HAVING in_total <> 0 OR out_total <> 0
");
$remark_stmt->bind_param("ss", $date, $group_id);
$remark_stmt->execute();
$remark_stats = $remark_stmt->get_result();

$user_stmt = $conn->prepare("
    SELECT 
        telegram_username,
        SUM(CASE WHEN type='IN'  THEN amount ELSE 0 END) AS in_total,
        SUM(CASE WHEN type='OUT' THEN amount ELSE 0 END) AS out_total
    FROM transactions
    WHERE DATE(created_at) = ?
    AND group_id = ?
    GROUP BY telegram_username
    HAVING in_total <> 0 OR out_total <> 0
");
$user_stmt->bind_param("ss", $date, $group_id);
$user_stmt->execute();
$user_stats = $user_stmt->get_result();

$op_stmt = $conn->prepare("
    SELECT 
        operator_name,
        SUM(CASE WHEN type='IN'  THEN amount ELSE 0 END) AS in_total,
        SUM(CASE WHEN type='OUT' THEN amount ELSE 0 END) AS out_total
    FROM transactions
    WHERE DATE(created_at) = ?
    AND group_id = ?
    GROUP BY operator_name
    HAVING in_total <> 0 OR out_total <> 0
");
$op_stmt->bind_param("ss", $date, $group_id);
$op_stmt->execute();
$op_stats = $op_stmt->get_result();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Ledger Dashboard</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    <style>
        body {
            background: #f3f5fb;
        }

        .navbar {
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08);
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .app-title {
            font-weight: 600;
            letter-spacing: .03em;
        }

        .main-wrapper {
            max-width: 1300px;
        }

        .card-soft {
            border-radius: 18px;
            border: 1px solid rgba(0, 0, 0, 0.03);
            box-shadow: 0 8px 18px rgba(15, 23, 42, 0.06);
        }

        .summary-card {
            background: linear-gradient(135deg, #e0f2fe, #eef2ff);
        }

        .summary-card h5 {
            font-weight: 600;
        }

        .badge-in {
            background-color: #16a34a;
        }

        .badge-out {
            background-color: #ef4444;
        }

        .section-title {
            font-weight: 600;
            font-size: 1.05rem;
            margin-bottom: .5rem;
        }

        .section-sub {
            font-size: .85rem;
            color: #6b7280;
        }

        table thead th {
            font-size: .8rem;
            text-transform: uppercase;
            letter-spacing: .05em;
        }

        .stats-table th,
        .stats-table td {
            font-size: .85rem;
        }

        .pill-label {
            font-size: .7rem;
            text-transform: uppercase;
            color: #6b7280;
        }

        .mt-50 {
            margin-top: 70px;
        }

        .no-style {
            text-decoration: none;
            color: black;
        }

        .small-font {
            font-size: 14px;
        }

        /* Mobile Styles */
        @media screen and (max-width: 768px) {
            * {
                font-size: 25px !important;
            }

            .main-wrapper {
                max-width: auto;
            }
        }
    </style>
</head>

<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark px-3">
        <a class="navbar-brand app-title" href="#">⚙ Ledger Control</a>
        <div class="ms-auto text-light small">
            <?php echo htmlspecialchars($_SESSION["admin_name"]); ?>
            &nbsp;•&nbsp;
            <a href="logout.php" class="link-warning text-decoration-none">Logout</a>
        </div>
    </nav>

    <div class="container-fluid my-4 main-wrapper">

        <div class="row">
            <div class="col-md-3 col-sm-12">
                <div class="card mt-50">
                    <div class="card-header text-center">
                        <div class="card-title fw-bold">Group List</div>
                    </div>
                    <div class="card-body">
                        <ul>
                            <?php
                            if ($group_list_r->num_rows > 0) {
                                while ($row = $group_list_r->fetch_assoc()) {
                            ?>
                                    <li class="<?php echo ($row['group_id'] == $group_id) ? 'bg-warning text-dark p-2' : ''; ?>">
                                        <a href="dashboard.php?group_id=<?= $row['group_id'] ?>" class="no-style"><?= $row['group_name'] ?></a>
                                    </li>
                            <?php
                                }
                            }
                            ?>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-md-9 col-sm-12">
                <!-- Top controls -->
                <div class="d-flex flex-wrap align-items-center gap-2 mb-3">
                    <form method="GET" class="d-flex flex-wrap align-items-center gap-2">
                        <input type="hidden" name="group_id" value="<?= $group_id ?>">
                        <div>
                            <label class="pill-label d-block mb-1">Date</label>
                            <input type="date" name="date" value="<?php echo htmlspecialchars($date); ?>" class="form-control">
                        </div>
                        <div class="mt-3">
                            <button class="btn btn-primary btn-sm mt-1">Load</button>
                        </div>
                    </form>
                    <div class="mt-3 ms-auto">
                        <a href="export.php?date=<?php echo urlencode($date); ?>" class="btn btn-success btn-sm mt-1">
                            Export CSV
                        </a>
                    </div>
                </div>

                <!-- Settings + Summary in two columns -->
                <div class="row g-3 mb-3">
                    <!-- Settings -->
                    <div class="col-lg-4">
                        <div class="card card-soft h-100">
                            <div class="card-header bg-white border-0 pb-0">
                                <div class="section-title">Exchange & Fee</div>
                                <div class="section-sub">Change today’s rate and fee percentage.</div>
                            </div>
                            <div class="card-body">
                                <form method="POST" class="row g-3">
                                    <div class="col-12">
                                        <label class="form-label small">Exchange Rate</label>
                                        <input type="number" step="0.0001" name="exchange_rate"
                                            value="<?php echo htmlspecialchars($exchange_rate); ?>" class="form-control">
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label small">Fee Rate (%)</label>
                                        <input type="number" step="0.01" name="fee_rate"
                                            value="<?php echo htmlspecialchars($fee_rate); ?>" class="form-control">
                                    </div>
                                    <div class="col-12 d-grid">
                                        <button type="submit" name="update_settings" class="btn btn-primary mt-1">
                                            Save Settings
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Summary -->
                    <div class="col-lg-8">
                        <div class="card card-soft summary-card h-100">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <h5 class="mb-0">Summary (<?php echo htmlspecialchars($date); ?>)</h5>
                                        <span class="pill-label">
                                            Exchange: <?php echo number_format($exchange_rate, 4); ?> •
                                            Fee: <?php echo number_format($fee_rate, 2); ?>%
                                        </span>
                                    </div>
                                </div>

                                <div class="row g-3 mt-1">
                                    <div class="col-md-4 col-6 mb-2">
                                        <div class="small text-muted">Total IN</div>
                                        <div class="fs-5 fw-semibold text-success">
                                            <div>
                                                <?php echo number_format($total_in, 2); ?>
                                            </div>
                                            <div>
                                                <span class="small-font">(INR: <?php echo number_format($total_in_rs, 2); ?>)</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-6 mb-2">
                                        <div class="small text-muted">Total OUT</div>
                                        <div class="fs-5 fw-semibold text-danger">
                                            <div>
                                                <?php echo number_format($total_out, 2); ?>
                                            </div>
                                            <div>
                                                <span class="small-font">(INR: <?php echo number_format($total_out_rs, 2); ?>)</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-6 mb-2">
                                        <div class="small text-muted">Net (IN - OUT)</div>
                                        <div class="fs-5 fw-semibold">
                                            <?php echo number_format($net, 2); ?>
                                        </div>
                                    </div>
                                </div>

                                <hr class="my-3">

                                <div class="row g-md-3">
                                    <div class="col-md-4 col-6 mb-2">
                                        <div class="small text-muted">IN (USDT)</div>
                                        <div class="fw-semibold">
                                            <?php echo number_format($in_usdt, 2); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-6 mb-2">
                                        <div class="small text-muted">Fee (USDT)</div>
                                        <div class="fw-semibold">
                                            <?php echo number_format($fee_usdt, 2); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-6 mb-2">
                                        <div class="small text-muted">Should Payout (USDT)</div>
                                        <div class="fw-semibold">
                                            <?php echo number_format($should_payout_usdt, 2); ?>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-6 mb-2">
                                        <div class="small text-muted mt-2">Already Paid (USDT)</div>
                                        <div class="fw-semibold">
                                            <?php echo number_format($out_usdt, 2); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-6 mb-2">
                                        <div class="small text-muted mt-2">Pending (USDT)</div>
                                        <div class="fw-semibold text-warning">
                                            <?php echo number_format($pending_usdt, 2); ?>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-6 mb-2">
                                        <div class="small text-muted mt-2">Profit (USDT)</div>
                                        <div class="fs-5 fw-semibold <?php echo ($profit_ustd >= 0) ? 'text-success' : 'text-danger'; ?>">
                                            <div>
                                                <?php echo number_format($profit_ustd, 2); ?>
                                            </div>
                                            <div>
                                                <span class="small-font">(INR: <?php echo number_format($profit_in_rs, 2); ?>)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transactions -->
                <div class="card card-soft mb-4">
                    <div class="card-header bg-white border-0 pb-0">
                        <div class="section-title">Transactions</div>
                        <div class="section-sub">All entries for the selected date.</div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-dark">
                                    <tr>
                                        <th>Date/Time</th>
                                        <th>User</th>
                                        <th>Type</th>
                                        <th>Amount</th>
                                        <th>Remark</th>
                                        <th>Operator</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while ($row = $logs->fetch_assoc()): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($row["created_at"]); ?></td>
                                            <td><?php echo htmlspecialchars($row["telegram_username"]); ?></td>
                                            <td>
                                                <?php if ($row["type"] === "IN"): ?>
                                                    <span class="badge badge-in">IN</span>
                                                <?php else: ?>
                                                    <span class="badge badge-out">OUT</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo number_format((float)$row["amount"], 2); ?></td>
                                            <td><?php echo htmlspecialchars($row["remark"]); ?></td>
                                            <td><?php echo htmlspecialchars($row["operator_name"] ?: "TelegramBot"); ?></td>
                                        </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Stats sections -->
                <div class="row g-3 mb-5">
                    <div class="col-lg-4">
                        <div class="card card-soft h-100">
                            <div class="card-header bg-white border-0 pb-0">
                                <div class="section-title">Stats by Remark</div>
                                <div class="section-sub">Grouped by transaction remark.</div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-sm table-bordered stats-table mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Remark</th>
                                                <th>Total IN</th>
                                                <th>Total OUT</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if ($remark_stats->num_rows === 0): ?>
                                                <tr>
                                                    <td colspan="3" class="text-muted text-center">No data</td>
                                                </tr>
                                            <?php else: ?>
                                                <?php while ($r = $remark_stats->fetch_assoc()): ?>
                                                    <tr>
                                                        <td><?php echo htmlspecialchars($r["remark"]); ?></td>
                                                        <td><?php echo number_format((float)$r["in_total"], 2); ?></td>
                                                        <td><?php echo number_format((float)$r["out_total"], 2); ?></td>
                                                    </tr>
                                                <?php endwhile; ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-soft h-100">
                            <div class="card-header bg-white border-0 pb-0">
                                <div class="section-title">Stats by User</div>
                                <div class="section-sub">Telegram usernames.</div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-sm table-bordered stats-table mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th>User</th>
                                                <th>Total IN</th>
                                                <th>Total OUT</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if ($user_stats->num_rows === 0): ?>
                                                <tr>
                                                    <td colspan="3" class="text-muted text-center">No data</td>
                                                </tr>
                                            <?php else: ?>
                                                <?php while ($u = $user_stats->fetch_assoc()): ?>
                                                    <tr>
                                                        <td><?php echo htmlspecialchars($u["telegram_username"]); ?></td>
                                                        <td><?php echo number_format((float)$u["in_total"], 2); ?></td>
                                                        <td><?php echo number_format((float)$u["out_total"], 2); ?></td>
                                                    </tr>
                                                <?php endwhile; ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-soft h-100">
                            <div class="card-header bg-white border-0 pb-0">
                                <div class="section-title">Stats by Operator</div>
                                <div class="section-sub">Who executed the commands.</div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-sm table-bordered stats-table mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Operator</th>
                                                <th>Total IN</th>
                                                <th>Total OUT</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if ($op_stats->num_rows === 0): ?>
                                                <tr>
                                                    <td colspan="3" class="text-muted text-center">No data</td>
                                                </tr>
                                            <?php else: ?>
                                                <?php while ($o = $op_stats->fetch_assoc()): ?>
                                                    <tr>
                                                        <td><?php echo htmlspecialchars($o["operator_name"]); ?></td>
                                                        <td><?php echo number_format((float)$o["in_total"], 2); ?></td>
                                                        <td><?php echo number_format((float)$o["out_total"], 2); ?></td>
                                                    </tr>
                                                <?php endwhile; ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</body>

</html>