<?php
// Test token generation and decryption
require_once "../config.php";
require_once "../link_crypto.php";

echo "Testing Token Generation and Decryption\n\n";

$uid = 1310401997;
$start_date = "2025-12-28 00:00:00";
$end_date = "2025-12-28 23:59:59";

echo "Input:\n";
echo "  UID: $uid\n";
echo "  Start: $start_date\n";
echo "  End: $end_date\n\n";

// Generate token
$token = generate_secure_token($uid, $start_date, $end_date);
echo "Generated Token:\n  $token\n\n";

// Try to decrypt it
$decrypted = decrypt_secure_token($token);
echo "Decrypted Payload:\n";
print_r($decrypted);

if ($decrypted && $decrypted['uid'] == $uid) {
    echo "\n✅ Token generation and decryption WORKING!\n";
} else {
    echo "\n❌ Token generation or decryption FAILED!\n";
}
?>
