<?php
// file: api/set_exchange.php
require_once "../config.php";

header('Content-Type: application/json');

// Enable error logging
error_log("=== set_exchange.php called ===");
error_log("REQUEST_METHOD: " . $_SERVER['REQUEST_METHOD']);
error_log("POST data: " . print_r($_POST, true));

// 1) Only POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    error_log("ERROR: Invalid request method - " . $_SERVER['REQUEST_METHOD']);
    echo json_encode(['error' => 'Invalid request method']);
    exit;
}

// Read data from both POST and JSON body
$data = $_POST;


if (empty($data)) {
    $raw = file_get_contents("php://input");
    if (!empty($raw)) {
        $json = json_decode($raw, true);
        if (is_array($json)) {
            $data = $json;
        }
    }
}

// error_log("Parsed data: " . print_r($data, true));
// exit;

// 2) Check API secret
$client_secret = $data['api_secret'] ?? '';
if ($client_secret !== API_SECRET) {
    http_response_code(401);
    error_log("ERROR: Unauthorized - secret mismatch");
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// 3) Read and validate rate
$rate_raw = $data['exchange_rate'] ?? '';
$rate = floatval($rate_raw);

$to_pay_rate = $data['to_pay_rate'] ?? 109;
$to_pay_rate = floatval($to_pay_rate);

$group_id = $data['group_id'] ?? '';
$group_name = $data['group_name'] ?? '';


error_log("Exchange rate received: " . $rate);

if ($rate <= 0) {
    http_response_code(400);
    error_log("ERROR: Invalid exchange rate - " . $rate_raw);
    echo json_encode(['error' => 'Invalid exchange rate']);
    exit;
}

// 4) Save into settings table (id=1 row)
$stmt = $conn->prepare("
    INSERT INTO settings (group_id, exchange_rate, to_pay_rate, group_name)
    VALUES (?, ?, ?, ?)
    ON DUPLICATE KEY UPDATE 
        exchange_rate = VALUES(exchange_rate),
        to_pay_rate = VALUES(to_pay_rate),
        group_name = VALUES(group_name)
");


// 3. Bind parameters
// "d" = double (rate), "i" = integer (group_id). Change "i" to "s" if group_id is a string.
$stmt->bind_param("sdds", $group_id, $rate, $to_pay_rate, $group_name);

if ($stmt->execute()) {
    error_log("SUCCESS: Exchange rate updated to " . $rate . " for group " . $group_id);
    echo json_encode([
        'status' => 'success',
        'exchange_rate' => $rate
    ]);
} else {
    http_response_code(500);
    error_log("ERROR: DB error - " . $stmt->error);
    echo json_encode(['error' => 'DB error: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
