<?php
require_once "../config.php";

header('Content-Type: application/json');

$date = $_GET["date"] ?? date("Y-m-d");

// Fetch totals grouped by type
$stmt = $conn->prepare("
    SELECT type, SUM(amount) AS total 
    FROM transactions 
    WHERE DATE(created_at) = ?
    GROUP BY type
");
$stmt->bind_param("s", $date);
$stmt->execute();
$res = $stmt->get_result();

$data = ["IN" => 0, "OUT" => 0];

while ($row = $res->fetch_assoc()) {
    $data[$row["type"]] = (float)$row["total"];
}

$stmt->close();
$conn->close();

echo json_encode($data);