<?php
// file: api/generate_link.php
require_once "../config.php";
require_once "../link_crypto.php";

header('Content-Type: application/json');

// Get parameters
$uid = $_GET['uid'] ?? '';
$gid = $_GET['gid'] ?? '';
$start_date = $_GET['start_date'] ?? '';
$end_date = $_GET['end_date'] ?? '';

if (empty($uid) || empty($gid)) {
    http_response_code(400);
    echo json_encode(["error" => "Missing parameters"]);
    exit;
}

// Generate token
$token = generate_secure_token($uid, $gid, $start_date, $end_date);

// Construct URL
// IMPORTANT: Change this to your real domain when deploying!
$base_url = "https://partylimes.com/ledger/user_ledger.php";
$full_link = $base_url . "?token=" . urlencode($token);

error_log("Generated secure link for uid=$uid, gid=$gid");

echo json_encode(["link" => $full_link]);
?>
